%Example: Run a simulation with a default conventional vehicle
clear

%% Create a vehicle configuration, load the mission
% Creating a configuration involves two steps:
%   - Specify each components' name in a vehConf.
%   - Load all the components using createConfiguration. 

% The configuration contains the components names. Start with a default
% configuration and modify its fields if needed. The corresponding
% components must exist in the library folder.
conf = vehConf('conv');

% Create the vehicle data using createConfiguration
veh = createVehicle(conf);

% Select the mission. This must be an existing .mat file in the library
mission_name = "wltc3";

veh.ctrl = designEffShiftLogic(veh);

%% Run simulation
[results, veh, prof, info] = vehicleSim(veh, mission_name);

%% Plot
% Plot default profiles
mainProfiles(prof, veh);

% Plot selected profiles
mainProfiles(prof, [], ["rollForce", "dragForce", "gradeForce", "inertiaForce"]);
